//---------------------------------------------------------------------------
// Sample code for uM-FPU64 64-bit FLoating Point Coprocessor
// Micromega Corporation  www.micromegacorp.com
// Author: Cam Thompson
//
// @file    test_keypad.ino
// @target  Arduino
//
// This is a test routine for the uM-FPU64 LCD menu functions.
//
// @version
//  Mar 28, 2013
//  - original version for uM-FPU64
//---------------------------------------------------------------------------

#include <SPI.h>
#include <Fpu64.h>
#include <FpuSerial64.h>

//-------------------- uM-FPU Register Definitions -----------------------------
#define lastKeys    12                  // uM-FPU register

//-------------------- uM-FPU Function Definitions -----------------------------
#define initialize  0                   // uM-FPU user function
#define displayMenu 1                   // uM-FPU user function
#define waitKey 2                       // uM-FPU user function
#define readKey 3                       // uM-FPU user function

//-------------------- setup ------------------------------------------------

void setup()
{
  Serial.begin(9600);                   // print program title
  Serial.println();
  Serial.println("\nTest LCD-menu");
  
  SPI.begin();                          // initialize SPI and FPU
  Fpu.begin();

  if (Fpu.sync() == SYNC_CHAR)          // print FPU version
    FpuSerial.printVersionln();
  else
  {
    Serial.print("uM-FPU not detected");
    while(1) ;                          // stop if FPU not detected
  }

  Fpu.write(FCALL, initialize);        // initialize the LCD
  //Fpu.write(F_BREAK);
}

//-------------------- loop -------------------------------------------------

void loop()
{
  Fpu.write(STRSET);                   // get menu selection
  Fpu.writeString("Menu Test,Item 1,Item 2,Item 3,Item 4,Item 5");
  Fpu.write(SELECTA, 0, FCALL, displayMenu);
  Fpu.wait();
  
  Fpu.write(STRSET, 0);                // display selection
  Serial.print("Menu selection: ");
  FpuSerial.printLongln(0);
}

